<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */
 
  /*===================================================
    ShowFormSearch()
  ===================================================*/

  function ShowFormSearch() {

    // vars global configuration
    global $category_separator, $theme_path;

    // vars url & form
    global $cat;

    // vars messages
    global $msg;

    // vars template
    global $error_msg, $title, $url, $description, $category, $contact_name, $email, $custom_field_form;

    $title = $_POST['title'];

    // get category path
    $category_obj = new clsCategory;
    $category_obj->table_name = "idx_category";
    $category_obj->link_table_name = "idx_link";
    $category_obj->separator       = $category_separator;
    $category                      = $category_obj->DisplayCategoryListBox(-1);

    // generate custom field
    $links_obj                                    = new clsLink;
    $links_obj->table_name                        = "idx_link";
    $links_obj->category_table_name               = "idx_category";
    $links_obj->autogenerate_form_text            = $msg["00001"];
    $links_obj->autogenerate_form_textarea        = $msg["00002"];
    $links_obj->autogenerate_form_image_add       = $msg["00005"];
    $links_obj->autogenerate_form_file_add        = $msg["00005"];
    $links_obj->autogenerate_form_select          = $msg["00007"];
    $links_obj->autogenerate_form_multiselect     = $msg["00008"];
    $links_obj->autogenerate_form_checkbox        = $msg["00009"];
    $links_obj->autogenerate_form_radio           = $msg["00010"];
    $links_obj->autogenerate_form_date            = $msg["00011"];
    $links_obj->autogenerate_form_datetime        = $msg["00012"];
    $links_obj->autogenerate_form_template        = $theme_path . "custom_field_form_rows.html";
    $custom_field_form                            = $links_obj->GenerateCustomFieldForm(true);

    DisplayTemplate($theme_path . "power_search_form.html",
                    "\$error_msg,\$title,\$url,\$description,\$category,\$contact_name,\$email,\$custom_field_form");
  }


  /*===================================================
    ProcessFormSearch()
  ===================================================*/
  
  function ProcessFormSearch() {

    // vars global configuration
    global $theme_path, $category_separator, $search_max_rows, $max_rows, $theme_name;

    // vars url & form
    global $cat;

    // vars messages
    global $msg;

    // vars template
    global $link, $num_links, $pagination;

    $users_obj = new clsUsers;
    $users_obj->table_name = "idx_users";

    $category_obj = new clsCategory;
    $category_obj->table_name = "idx_category";

    // get field
    $links_obj = new clsLink;
    $links_obj->table_name = "idx_link";
    $links_obj->category_table_name = "idx_category";
    $fields                         = $links_obj->GetFields();

    // querying
    $cats     = $category_obj->GetChildren($cat);
    $num_cats = count($cats);
    $query = "
      select idx_link.*, 
             if (isnull(premium) || expire < now() || paid != 1, 0, premium) premium,
             if (isnull(sponsored) || expire < now() || paid != 1, 0, sponsored) sponsored
      from idx_link
           left join idx_paid_listing on (idx_link.link_id = idx_paid_listing.link_id)
           left join idx_pagerank on (idx_link.link_id = idx_pagerank.link_id)
		  where 0=0 ";
    
    $i = 0;
    $count_fields = @count($fields);
    while ($i < $count_fields) {
      $field = $fields[$i];

      global $$field;

      if (!empty($_POST["title"]))
        $title = $_POST["title"];
      else
        $title = $_GET["title"];

      if (!empty($_POST["cat"]))
        $cat = $_POST["cat"];
      else
        $cat = $_GET["cat"];

      if ($field == 'category_id' && !empty($cat)) {
        $j = 0;
        $query .= "and ($field = $cats[$j] ";

        while ($j < $num_cats) {
          $query .= "or $field = $cats[$j] or cat1 = $cats[$j] or cat2 = $cats[$j] ";
          $j++;
        }

        $query .= ") ";
      }
      elseif (!empty($$field)) {
        if ($i >= $links_obj->custom_field_offset && (!$links_obj->fields_searchable[$i] || $links_obj->fields_type[$i] == 'IMAGE' || $links_obj->fields_type[$i] == 'FILE')) {
          $i++;
          continue;
        }
        if (!is_array($$field)) {
          $query .= "and $field like '%" . $$field . "%' ";
        }
        else {
          $custom_fields = $$field;
          $query .= "and (0!=0 ";
          while (list($k, $v) = @each($custom_fields)) {
            $query .= "or $field like '%" . $v . "%' ";
          }
          $query .= ")";
        }
      }

      $i++;
    }

    $c  = $category_obj->GetHiddenCategories();
    $c2 = $category_obj->GetMemberOnlyCategories();

    // filter unhide
    while (list(, $v) = @each($c)) {
      $query .= " and category_id != $v";
    }

    // filter member only
    if (!$users_obj->GetUserAuthentication() == 0) {
      while (list(, $v) = @each($c2)) {
        $query .= " and category_id != $v";
      }
    }

    if ($_COOKIE['COOKIE_SORT_BY']) {
      $query .= "	order by sponsored desc, premium desc, $_COOKIE[COOKIE_SORT_BY] $_COOKIE[COOKIE_SORT_ORDER]";
    }
    else {
      $query .= " order by sponsored desc, premium desc, bid desc";
    }

    $links_obj->query                 = $query;
    $links_obj->template_file         = $theme_path . "rows.html";
    $links_obj->date_format           = $msg["10023"];
    $links_obj->header                = $msg["10022"];
    $links_obj->paging                = true;
    $links_obj->pg_size               = ($search_max_rows) ? $search_max_rows : $max_rows;
    $links_obj->href                  = "power_search.php";
    $links_obj->rating_image_path     = "themes/" . $theme_name . "/images/rating/";
    $links_obj->rev_rating_image_path = "themes/" . $theme_name . "/images/review/";

    // get more param for custom fields

    $i                                = $links_obj->custom_field_offset;

    $count_fields = @count($fields);
    while ($i < $count_fields) {
      $field = $fields[$i];

      global $$field;
      
      if (!$links_obj->fields_searchable[$i] || $links_obj->fields_type[$i] == 'IMAGE' || $links_obj->fields_type[$i] == 'FILE') {
        $i++;
        continue;
      }

      if (!is_array($$field)) {
        $custom_field_param .= "&" . $field . "=" . $$field;
      }
      else {
        $custom_fields = $$field;
        while (list($k, $v) = @each($custom_fields)) {
          $custom_field_param .= "&" . $field . "[]=" . $v;
        }
      }
      $i++;
    }

    $links_obj->more_param
                =
      "&pflag=search&title=$title&url=$url&description=$description&cat=$cat&contact_name=$contact_name&email=$email"
      . $custom_field_param;

    $link       = $links_obj->Display();
    $num_links  = $links_obj->record_count_of_display;
    $pagination = $links_obj->pagination;

    DisplayTemplate($theme_path . "power_search_result.html", "\$link,\$num_links,\$pagination");
  }


  /*===================================================
    main
  ===================================================*/

  include "application.php";

  RunPreFilter(__FILE__);

  if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    RemoveFilter("page_cache");
    setcookie("COOKIE_SORT_BY", $_POST['sort_by'], 0, "/",  "", 0);
    setcookie("COOKIE_SORT_ORDER", $_POST['sort_order'], 0, "/",  "", 0);
    Redirect($_SERVER['REQUEST_URI']);
  }

  if (empty($pflag)) {
    ShowFormSearch();
  }
  elseif ($pflag == 'search') {
    ProcessFormSearch();
  }

  RunPostFilter(__FILE__);

?>